# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import os
import wx
import sys
try:
    if getattr(sys, 'frozen', False):
        sys.path.append(sys._MEIPASS)
    else:
        sys.path.append(os.path.realpath("../.."))
except Exception:
    sys.path.append(os.path.realpath("../.."))
if 'wxMSW' in wx.PlatformInfo:
    import ctypes
    myappid = 'BTM3000'
    try:
        ctypes.windll.shell32.SetCurrentProcessExplicitAppUserModelID(myappid)
    except Exception:
        pass

from wx import App

from BTM3000_Abstraction import BTM_Abstraction
from BTM3000_Control import Control
from BTM3000_Interaction import Interaction
from BTM3000_Presentation import Presentation


class BTM3000(App):
    def OnInit(self):
        abstraction = BTM_Abstraction()
        presentation = Presentation()
        interaction = Interaction()
        control = Control(abstraction, interaction, presentation)
        if not hasattr(control, "presentation"):
            if not hasattr(control, "update_mode"):
                return False
        if hasattr(control, "presentation"):
            presentation.frame.Show()
        return True


if __name__ == '__main__':
    application = BTM3000(redirect=False)
    application.MainLoop()
